/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Adapted by S.Guillitte from Fire by @301z

const mat2 m2 = mat2(.8,.6,-.6,.8);


float noise(in vec2 p){

    float res=0.;
    float f=1.;
	for( int i=0; i< 2; i++ ) 
	{		
        p=m2*p*f+.6;     
        f*=1.2;
        res+=sin(p.x+sin(2.*p.y));
	}        	
	return abs(res/4.);
}

float fbm(in vec2 p){
	
    float res=0.;
    float f=1.;
	for( int i=0; i< 7; i++ ) 
	{
        res+=noise(f*p)/f;
        f*=2.;
	}        	
	return res;
}

void main( void ) {
	
	vec2 p = gl_FragCoord.xy * 8.0 / iResolution.xx;
    float t = iGlobalTime;
	float q = fbm(p - t * 0.1);
	vec2 r = vec2(fbm(q - p.yx + t * 0.7 ), fbm(p + q - t * 0.4));
    float s = fbm(p + r);
	vec3 c = clamp(vec3(0.1+s*.7+r.x-.7*r.y, r.x-r.y, 0.)*1.1,0.,1.);
	gl_FragColor = vec4(c * cos(1.57 * gl_FragCoord.y / iResolution.y), 1.0);
}
